//
//  MCCIPUpdaterDelegate.h
//  MCCloud
//
//  Created by Thomas Bartelmess on 11.02.10.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCNetComm/MCRestRequestCredentialsProviderProtocol.h>
#import "MCCIPUpdaterDefines.h"
@class MCCIPUpdater;


/*!
 @protocol	MCCIPUpdaterDelegate
 @abstract	The MCCIPUpdaterDelegate protocol defines the methods that a delegate of MCCIPUpdater should implement.
 @discussion All methods that inform the delegate about a error MUST be implmented, all methods that are just for success feedback are optional.
 */

@protocol MCCIPUpdaterDelegate
@required

- (id <MCRestRequestCredentialsProvider>)credentialProvider;

@optional

/*!
    @function	ipUpdater:updatedIPForApplication:toIP:
    @abstract   Sent when a MCCIPUpdater successfully updated a IPAddress on MCCloud
    @discussion 
    @param      ipUpdater MCCIPUpdater that reports the IP updated on MCCloud
	@param      updatedIPForApplication Application that is linked to the IP address
	@param      ip The IPAddress that is now stored on the server
*/

- (void)ipUpdater:(MCCIPUpdater *)ipUpdater updatedIPForApplication:(NSString *)application toIP:(NSString *)ipAddress;

/*!
    @function	ipUpdater:gotPortResults:forIP:
    @abstract   Sent when a MCCIPUpdater got results for a port check request from MCCloud
    @discussion The MCCloud checks if the ports are available from extern. Caused by the 10 second socket timeout, it can take some time till this callback is executed.
    @param      ipUpdater MCCIPUpdater that was responsible for the port checking
	@param      gotPortResult port scan result
	@param      forIP IPAddress that was checked
*/

- (void)ipUpdater:(MCCIPUpdater *)ipUpdater gotPortScanResult:(MCPortCheckResult)result forIP:(NSString *)ip;

@required

/*!
	@function	ipUpdater:failedToUpdateIPForApplication:error:
	@abstract   Sent when a MCCIPUpdater failed to update the IPAddress
	@discussion 
	@param      ipUpdater that tried to update the IPAddress on MCCloud
	@param      failedToUpdateIPForApplication the application that's IP ipUpdater tried the update the IP for
	@param      An error object containing details of why the IP Updater faild to update the IP
 */


- (void)ipUpdater:(MCCIPUpdater *)ipUpdater failedToUpdateIPForApplication:(NSString *)application error:(NSError *)error;

/*!
 @function	 ipUpdater:faildToCheckPorts:forIP:error:
 @abstract   Sent when a MCCIPUpdater faild to check ports
 @discussion This method is not send if a port was not reachable from extern. This information is passed in the success callback information. When this method is called MCCIPUpdater was not able to check the IPs. e.g MCCloud was not reachable or the IPAddress was wrong.
 @param      ipUpdater that tried to update to check ports on MCCloud
 @param      ports array with the ports that MCCIPUpdater tried to check
 @param		 ip IPAddress that MCCIPUpdater tried to check the ports on
 @param      An error object containing details of why the IP Updater failed to check the ports
 */

- (void)ipUpdater:(MCCIPUpdater *)ipUpdater faildToCheckPortWithError:(NSError *)error;

@end
